package gov.va.med.mhv.admin.web.formbean;

import gov.va.med.mhv.admin.dto.EmployeeDTO;
import gov.va.med.mhv.admin.dto.EmployeeOrgRoleDTO;
import gov.va.med.mhv.admin.dto.OrgDTO;
import gov.va.med.mhv.admin.dto.OrgTypeRoleDTO;
import gov.va.med.mhv.admin.service.vastaff.EmployeeRoleManagementService;
import gov.va.med.mhv.admin.web.util.SessionUtil;
import gov.va.med.mhv.admin.web.util.SpringContext;
import gov.va.med.mhv.common.api.exception.MHVException;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
//import javax.faces.model.SelectItem;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;

@ManagedBean(name="assignNewRoleForm")
@ViewScoped
public class AssignNewRoleFormBean implements Serializable{
	
	private static final Long NO_SELECTION = -1L;
	private static final String NO_SELECTION_STRING = "no_selection";

	private static final long serialVersionUID = -4812667309686055817L;

	private static Logger log = LogManager.getLogger(AssignNewRoleFormBean.class);
	
	List<OrgDTO> organizations = null;
	Set<String> organizationLevels = null;
	List<OrgDTO> filteredOrganizations = null;
	List<OrgTypeRoleDTO> roles = null;
	
	String selectedOrganizationLevel;
	Long selectedOrganization;
	Long selectedRole;

	
	@ManagedProperty(value="#{staffSearchResults}")
	SearchResultsFormBean searchResults;
	
	public AssignNewRoleFormBean() {
	}

	
	private OrgTypeRoleDTO getRoleForID(Long id) {
		OrgTypeRoleDTO result = null;
		if (roles != null && id != null) {
			for (OrgTypeRoleDTO o : roles) {
				if (id.equals(o.getId())) {
					result = o;
					break;
				}
			}
		}
		return result;
	}
	
	
	private OrgDTO getOrgForID(Long id) {
		OrgDTO result = null;
		if (organizations != null && id != null) {
			for (OrgDTO o : organizations) {
				if (id.equals(o.getOrgId())) {
					result = o;
					break;
				}
			}
		}
		return result;
	}


	public String getSelectedOrganizationLevel() {
		return selectedOrganizationLevel;
	}

	public void setSelectedOrganizationLevel(String selectedOrganizationLevel) {
		this.selectedOrganizationLevel = selectedOrganizationLevel;
	}

	public Long getSelectedOrganization() {
		return selectedOrganization;
	}

	public void setSelectedOrganization(Long selectedOrganization) {
		this.selectedOrganization = selectedOrganization;
	}

	public Long getSelectedRole() {
		return selectedRole;
	}

	public void setSelectedRole(Long selectedRole) {
		this.selectedRole = selectedRole;
	}

	public void setOrganizationLevels(Set<String> organizationLevels) {
		this.organizationLevels = organizationLevels;
	}

	public void setFilteredOrganizations(List<OrgDTO> filteredOrganizations) {
		this.filteredOrganizations = filteredOrganizations;
	}

	public void setRoles(List<OrgTypeRoleDTO> roles) {
		this.roles = roles;
	}

	public Set<String> getOrganizationLevels() {
		if (organizationLevels == null || organizationLevels.isEmpty()) {
			List<OrgDTO> allOrgs = getOrganizations();
			organizationLevels = new TreeSet<String>();
			for (OrgDTO org : allOrgs) {
				organizationLevels.add(org.getTypeOfOrganization());
			}
		}
		return organizationLevels;
	}
	
	public List<OrgDTO> getFilteredOrganizations() {
		System.out.println("A1");
		if (filteredOrganizations == null || filteredOrganizations.isEmpty()) {
			System.out.println("A2");
			filteredOrganizations = new ArrayList<OrgDTO>();
	
			if (selectedOrganizationLevel != null && !NO_SELECTION_STRING.equals(selectedOrganizationLevel)) {
				System.out.println("A3");
				for (OrgDTO org : getOrganizations()) {
					System.out.println("A4");
					String typeOfOrganization = org.getTypeOfOrganization();
					System.out.println("Comparing: " + typeOfOrganization + " - " + selectedOrganizationLevel);
					if (typeOfOrganization != null && typeOfOrganization.equals(selectedOrganizationLevel)) {
						System.out.println("A5");
						filteredOrganizations.add(org);
					}
				}
			}
		}
		System.out.println("A6: Count=" + filteredOrganizations.size());
		return filteredOrganizations;
	}
	
	
	
	private List<OrgDTO> getOrganizations() {
		if (organizations == null || organizations.isEmpty()) {
			try {
				EmployeeRoleManagementService employeeRoleService = (EmployeeRoleManagementService) SpringContext.getApplicationContext().getBean("employeeRoleManagementServiceProxy");
				organizations = employeeRoleService.getOrganizationsEmployeeCanManage(SessionUtil.getCurrentUser().getEmployeeId());
				for(OrgDTO o : organizations) {  // TODO: Remove this loop
					System.out.println("Organization: " + o.getName() + " - " + o.getTypeOfOrganization());
				}
			} catch (BeansException e) {
				FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Failure loading Organization list."));
				log.error("Error loading Organization list.", e);
			} catch (MHVException e) {
				FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Failure loading Organization list."));
				log.error("Error loading Organization list.", e);
			}
		}
		return organizations;
	}
	
	
	public List<OrgTypeRoleDTO> getRoles() {
		if (selectedOrganization != null && !NO_SELECTION.equals(selectedOrganization)) {
			try {
				EmployeeRoleManagementService employeeRoleService = (EmployeeRoleManagementService) SpringContext.getApplicationContext().getBean("employeeRoleManagementServiceProxy");
				Long empId = SessionUtil.getCurrentUser().getEmployeeId();
				roles = employeeRoleService.getRolesAtOrganizationEmployeeCanManage(empId, selectedOrganization); //TODO: Or is the getFacilityInfoId() ?
			} catch (BeansException e) {
				FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Failure loading Organization list."));
				log.error("Error loading Organization list.", e);
			} catch (MHVException e) {
				FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Failure loading Organization list."));
				log.error("Error loading Organization list.", e);
			}
		}
		else {
			FacesContext.getCurrentInstance().addMessage("Please make an Organization selection.", new FacesMessage("Please make an Organization selection."));
		}
		return roles;
	}
	
	public void organizationLevelSelected() { //coordinate selected org, orgtype, role with these select items.
		System.out.println("Org Level Selected!");
		
		this.selectedOrganization = null;
		this.selectedRole = null;
		
		this.filteredOrganizations = null;
		this.roles = null;
		
	}
	
	public void organizationSelected() {
		System.out.println("Org Selected!");
		
		this.selectedRole = null;
		this.roles = null;
	}
	
	public void roleSelected() {
		System.out.println("Role Selected!");
	}
	
	public String save() {
		
		System.out.println("OrgLvl: '" + this.selectedOrganizationLevel + "'");
		System.out.println("Org: '" + this.selectedOrganization + "'");
		System.out.println("Role: '" + this.selectedRole + "'");
		
		if (selectedOrganizationLevel == null || NO_SELECTION_STRING.equals(selectedOrganizationLevel)
			|| selectedOrganization == null || NO_SELECTION.equals(selectedOrganization)
			|| selectedRole == null || NO_SELECTION.equals(selectedRole)) {
			System.out.println("non-selection detected");
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Please select an Organization Level, an Organization and a Role before saving."));
			
		}
		else {
			try {
				System.out.println("B1");
				EmployeeRoleManagementService employeeRoleService = (EmployeeRoleManagementService) SpringContext.getApplicationContext().getBean("employeeRoleManagementServiceProxy");
				EmployeeDTO authenticatedUser = SessionUtil.getCurrentUser();
				String managedUserName = searchResults.getManaged().getManagedEmployee().getUserName();
				System.out.println("userName: " + managedUserName);
				OrgDTO orgForID = getOrgForID(this.selectedOrganization);
				System.out.println("B2 " + orgForID.getOrgId());
				OrgTypeRoleDTO roleForID = getRoleForID(this.selectedRole);
				System.out.println("B3 " + roleForID.getId());
				EmployeeOrgRoleDTO eorDTO = employeeRoleService.assignEmployeeOrganizationRole(authenticatedUser.getEmployeeId(), managedUserName, orgForID.getOrgId(), roleForID.getRoleDTO().getRoleId());
				System.out.println("Saved!");
				List<EmployeeOrgRoleDTO> employeeOrgRoles = searchResults.getManaged().getManagedEmployee().getEmployeeOrgRoles();
				if (employeeOrgRoles == null) {
					employeeOrgRoles = new ArrayList<EmployeeOrgRoleDTO>();
					employeeOrgRoles.add(eorDTO);
					System.out.println("Added1");
				}
				else {
					employeeOrgRoles.add(eorDTO);
					System.out.println("Added2");
				}
				// TODO: remember the assignment or reload all roles for the managed user
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Role Successfully Added.", null));
			} catch (BeansException e) {
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Failure saving Role Assignment.", null));
				log.error("Error loading Organization list.", e);
			} catch (MHVException e) {
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Failure saving Role Assignment.", null));
				log.error("Error loading Organization list.", e);
			}
		}
		return "";
	}
	
	public String reset() {
		this.selectedOrganizationLevel = null;
		this.selectedOrganization = null;
		this.selectedRole = null;
		
		this.filteredOrganizations = null;
		this.roles = null;
		
		return "";
	}
	

	public SearchResultsFormBean getSearchResults() {
		return searchResults;
	}


	public void setSearchResults(SearchResultsFormBean searchResults) {
		this.searchResults = searchResults;
	}
	
	
}
